using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywoanie programu: Program plik");
      return;
    }
    String plik = args[0];

    StreamWriter sw;
    try
    {
      sw = new StreamWriter(plik);
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Otwarcie pliku {0} nie powiodo si.", plik);
      return;
    }

    Console.WriteLine(
      "Wprowadzaj wiersze tekstu. Aby zakoczy, wpisz 'quit'.");
    String line;
    try
    {
      do
      {
        line = Console.ReadLine();
        sw.WriteLine(line);
      }
      while(line != "quit");
      sw.Close();
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Wystpi bd podczas zapisu do pliku {0}.", plik);
      return;
    }
  }
}
